/*
 * Decompiled with CFR 0.152.
 */
package com.visigenic.vbroker.orb;

import com.visigenic.vbroker.orb.ORB;
import com.visigenic.vbroker.orb.OrbObject;
import com.visigenic.vbroker.util.DaemonThread;
import com.visigenic.vbroker.util.PropertyManager;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;

public class GarbageCollector
extends DaemonThread
implements OrbObject,
Observer {
    private ORB _orb;
    private Vector _collectables = new Vector();
    private int _timeout;
    private boolean _syncGC = true;

    public synchronized void addCollectable(Collectable collectable) {
        this._collectables.addElement(collectable);
        this.notify();
    }

    public void removeCollectable(Collectable collectable) {
        this._collectables.removeElement(collectable);
    }

    public void init(ORB oRB, Object[] objectArray) {
        this._orb = oRB;
        try {
            this.setName("GarbageCollector");
        }
        catch (SecurityException securityException) {}
        PropertyManager propertyManager = this._orb.getPropertyManager();
        this.update(propertyManager, "ORBsyncGC");
        this.update(propertyManager, "ORBgcTimeout");
        this.start();
    }

    public void update(Observable observable, Object object) {
        String string = (String)object;
        PropertyManager propertyManager = (PropertyManager)observable;
        if (string.equals("ORBsyncGC")) {
            this._syncGC = propertyManager.getBoolean(string);
            return;
        }
        if (string.equals("ORBgcTimeout")) {
            this._timeout = propertyManager.getInt(string) * 1000;
        }
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    GarbageCollector garbageCollector = this;
                    synchronized (garbageCollector) {
                        this.wait(this._timeout);
                    }
                    this.gc();
                }
            }
            catch (Exception exception) {
                if (!this._orb.debug) continue;
                this._orb.println("GarbageCollector caught an exception: " + exception);
                exception.printStackTrace();
                continue;
            }
            break;
        }
    }

    public void gc() {
        if (this._syncGC) {
            System.gc();
        }
        Dictionary dictionary = this._orb.threadLocalTable();
        Enumeration enumeration = dictionary.keys();
        while (enumeration.hasMoreElements()) {
            Thread thread = (Thread)enumeration.nextElement();
            if (thread.isAlive()) continue;
            if (this._orb.debug) {
                this._orb.println("Reaper: removing thread local objects for " + thread);
            }
            dictionary.remove(thread);
        }
        long l = System.currentTimeMillis();
        Enumeration enumeration2 = this._collectables.elements();
        while (enumeration2.hasMoreElements()) {
            ((Collectable)enumeration2.nextElement()).collect(l);
        }
    }

    interface Collectable {
        public void collect(long var1);
    }
}

